#include <stdio.h>
#include <syncobjs.hpp>
//---------------------------------------------------------------------------
class TComPort {
 private:
 void *hComm;
 TTimeStamp m_ConnectionStart;
 char PortParam[50];
 COMMTIMEOUTS PortTimeOuts;
 DCB CurDCB;
public:
 __fastcall TComPort();
 __fastcall ~TComPort();

 bool Opened;
 unsigned short PortNumber;             // 1  256
 unsigned int PortSpeed;                // /
 int TimeWait;                          //   , 
 char m_Phone[30];
 char TonePulse;                        //  ('T')   ('P')   
 int m_TimeOut;                         // , 
 int m_TimeConnection;                  //  
 bool blRTSMan;                         //  RTS
 int nDelay;                            //   

 bool __fastcall InitCom(void);
 void __fastcall CloseCom(void);
 int __fastcall ReceiveCom(unsigned char *Buffer, unsigned long Size);
 int __fastcall SendCom(unsigned char *Buffer, unsigned long Size);
 bool __fastcall ClearInputCom(void);
 bool __fastcall ClearOutputCom(void);
 bool __fastcall ClearSetRTS(bool OnOff);
 bool __fastcall ClearSetDTR(bool OnOff);
 bool __fastcall SetSpeed(int NewSpeed);
 bool __fastcall SetTimeOuts(int NewTimeWait);
 bool __fastcall SetTimeOutsDetail(int ReadInt, int ReadTotal, int ReadMult, int WriteMult, int WriteTotal);
 bool __fastcall IsConnected(void);
};
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
__fastcall TComPort::TComPort()
{
 Opened=false;
 blRTSMan=false;
 m_Phone[0]=0x0;
 nDelay=0;
 hComm=INVALID_HANDLE_VALUE;
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
__fastcall TComPort::~TComPort()
{
 CloseCom();
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
bool __fastcall  TComPort::InitCom(void)
{
 TTimeStamp TimeStart;         // 
 char init[50];
 DWORD done=0;
 DWORD evtMask=0;
 DWORD dwRes;
 bool Connected=false;
 unsigned long Received;

 char FileName[11]="\\\\.\\COM1";
 itoa(PortNumber,FileName+7,10);

 m_ConnectionStart=DateTimeToTimeStamp(Now());
 hComm=CreateFile(FileName,GENERIC_READ|GENERIC_WRITE,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0);
 if(hComm==INVALID_HANDLE_VALUE)
  return false;

//  
 GetCommState(hComm,&CurDCB); //   
 sprintf(PortParam,"baud=%d parity=N data=8 stop=1 octs=off",PortSpeed);
 if(!BuildCommDCB(PortParam,&CurDCB))
 {
  CloseCom();
  return false;
 }

 PortTimeOuts.ReadIntervalTimeout=TimeWait*1000;
 PortTimeOuts.ReadTotalTimeoutConstant=TimeWait*1000;
 PortTimeOuts.ReadTotalTimeoutMultiplier=TimeWait;
 PortTimeOuts.WriteTotalTimeoutMultiplier=TimeWait;
 PortTimeOuts.WriteTotalTimeoutConstant=TimeWait*100;

 if(!SetCommState(hComm,&CurDCB))
 {
  CloseCom();
  return false;
 }
 if(!SetCommTimeouts(hComm,&PortTimeOuts))
 {
  CloseCom();
  return false;
 }
 SetCommMask(hComm,EV_TXEMPTY);

 Opened=true;

 //   
 if(strlen(m_Phone))
 {
  //  
  //SetCommMask(hComm,EV_RLSD | EV_CTS | EV_DSR | EV_ERR | EV_RING | EV_RXCHAR | EV_RXFLAG | EV_TXEMPTY);
  SetCommMask(hComm,EV_RLSD | EV_ERR | EV_RXCHAR);
  // 
  sprintf(init,"AT&C1%c%c",0x0D,0x0A);
  if(!WriteFile(hComm,init,strlen(init),&done,NULL) || done!=strlen(init))
  {
   CloseCom();
   return false;
  }
  // 1 ,    ?
  Sleep(1000);
  PurgeComm(hComm,PURGE_RXCLEAR | PURGE_RXABORT);

  // 
  sprintf(init,"ATD%c%s%c%c",TonePulse,m_Phone,0x0D,0x0A);
  if(!WriteFile(hComm,init,strlen(init),&done,NULL) || done!=strlen(init))
  {
   CloseCom();
   return false;
  }

  // 
  Application->ProcessMessages();
  //    
  TimeStart=DateTimeToTimeStamp(Now());
  // 1 ,   ,   
  Sleep(1000);
  //   
  // - ,       -   ,    
  while((DateTimeToTimeStamp(Now()).Time-TimeStart.Time)<m_TimeConnection*1000)
  {
   evtMask=0;
   WaitCommEvent(hComm,&evtMask,NULL);
   if(evtMask&EV_RXCHAR)
   {
    if(!ReadFile(hComm,init,80,&Received,NULL))
    {
     CloseCom();
     return false;
    }
    if(strstr(init,"NO CARRIER"))
    {
     CloseCom();
     return false;
    }
    if(strstr(init,"CONNECT"))
    {
     PurgeComm(hComm,PURGE_TXABORT | PURGE_RXABORT | PURGE_TXCLEAR | PURGE_RXCLEAR);
     Connected=true;
     break;
    }
    if(strstr(init,"NO ANSWER"))
    {
     CloseCom();
     return false;
    }
   }
   // 
   Application->ProcessMessages();
   //  
   GetCommModemStatus(hComm,&evtMask);
   Application->ProcessMessages();

   //  
   /*if(evtMask&MS_RLSD_ON)
   {
    PurgeComm(hComm,PURGE_TXABORT | PURGE_RXABORT | PURGE_TXCLEAR | PURGE_RXCLEAR);
    Connected=true;
    break;
   }*/
   //   -, ,  
   Sleep(500);
   Application->ProcessMessages();
  }
  if(Connected)
   return true;
  else
  {
   //        
   CloseCom();
   return false;
  }
 }

 //     
 if(nDelay)
 {
  Application->ProcessMessages();
  TimeStart=DateTimeToTimeStamp(Now());
  while((DateTimeToTimeStamp(Now()).Time-TimeStart.Time)<nDelay*1000)
  {
   Sleep(100);
   ReadFile(hComm,init,6,&Received,NULL);
   if(strstr(init,"PRIVET"))
    break;
   Application->ProcessMessages();
  }
 }
 return true;
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
void __fastcall  TComPort::CloseCom(void)
{
 try {
  if(hComm!=INVALID_HANDLE_VALUE)
  {
   CancelIo(hComm);
   if(strlen(m_Phone))
   {
    char out[6];
    DWORD done;
    PurgeComm(hComm,PURGE_TXABORT | PURGE_RXABORT | PURGE_TXCLEAR | PURGE_RXCLEAR);
    sprintf(out,"+++");
    WriteFile(hComm,out,strlen(out),&done,NULL);
    Sleep(3000);
    PurgeComm(hComm,PURGE_TXABORT | PURGE_RXABORT | PURGE_TXCLEAR | PURGE_RXCLEAR);
    sprintf(out,"ATH%c%c",0x0D,0x0A);
    WriteFile(hComm,out,strlen(out),&done,NULL);
    Sleep(3000);
    PurgeComm(hComm,PURGE_TXABORT | PURGE_RXABORT | PURGE_TXCLEAR | PURGE_RXCLEAR);
   }
   CloseHandle(hComm);
  }
 }
 catch(...) {;}
 hComm=INVALID_HANDLE_VALUE;
 Opened=false;
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
int __fastcall TComPort::ReceiveCom(unsigned char *Buffer, unsigned long Size)
{
 unsigned long Received;

 if(!IsConnected())
  if(!InitCom())
   return -1;

/* if(blRTSMan)
  ClearSetRTS(false);*/
 if(!ReadFile(hComm,Buffer,Size,&Received,NULL))
  return -1;
 else
  return Received;

// CancelIo(hComm);
// return -1;
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
int __fastcall TComPort::SendCom(unsigned char *Buffer, unsigned long Size)
{
 bool blSucc;
 unsigned long Sended=0;
 if(!IsConnected())
  if(!InitCom())
   return -1;

/* if(blRTSMan)
  ClearSetRTS(true);*/
 if(m_Phone[0]==0x0)
 {
  blSucc=WriteFile(hComm,Buffer,Size,&Sended,NULL);
  if(blSucc)
  {
   DWORD evtMask=0;
   WaitCommEvent(hComm,&evtMask,NULL);
   if(evtMask&EV_TXEMPTY)
    return Sended;
   else
    return -1;
  }  
  else
   return -1;
 }
 //   
 if(!WriteFile(hComm,Buffer,Size,&Sended,NULL))
  return -1;
 else
 {
  DWORD evtMask=0;
  //  
  GetCommModemStatus(hComm,&evtMask);
  //SetCommMask(hComm,EV_BREAK | EV_RLSD | EV_CTS | EV_DSR | EV_ERR | EV_RING | EV_RXCHAR | EV_RXFLAG | EV_TXEMPTY);
  //WaitCommEvent(hComm,&evtMask,NULL);
  if(evtMask&EV_TXEMPTY || evtMask&EV_RXCHAR || evtMask&MS_CTS_ON)
   return Sended;
  else
   return -1;
 }
 //return Sended;
/* CancelIo(hComm);
 throw ("   - ");
 return -1;*/
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
bool __fastcall TComPort::ClearInputCom(void)
{
 if(hComm==INVALID_HANDLE_VALUE)
  throw ("    COM-");
 return PurgeComm(hComm,PURGE_RXCLEAR|PURGE_RXABORT);
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
bool __fastcall TComPort::ClearOutputCom(void)
{
 if(hComm==INVALID_HANDLE_VALUE)
  throw ("    COM-");
 return PurgeComm(hComm,PURGE_TXCLEAR|PURGE_TXABORT);
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
bool __fastcall TComPort::ClearSetRTS(bool OnOff)
{
 if(hComm==INVALID_HANDLE_VALUE)
  throw ("    COM-");
 if(OnOff)
  return EscapeCommFunction(hComm, SETRTS);
 else
  return EscapeCommFunction(hComm, CLRRTS);
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
bool __fastcall TComPort::ClearSetDTR(bool OnOff)
{
 if(hComm==INVALID_HANDLE_VALUE)
  throw ("    COM-");
 if(OnOff)
  return EscapeCommFunction(hComm, SETDTR);
 else
  return EscapeCommFunction(hComm, CLRDTR);
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
bool __fastcall TComPort::IsConnected(void)
{
 //  
 if(hComm!=INVALID_HANDLE_VALUE && !strlen(m_Phone))
  return true;
 //    
 if(hComm!=INVALID_HANDLE_VALUE)
 {
  DWORD evtMask=0;
  if(!SetCommMask(hComm,EV_RLSD | EV_CTS | EV_DSR | EV_ERR | EV_RING | EV_RXCHAR | EV_RXFLAG | EV_TXEMPTY))
   return false;
  GetCommModemStatus(hComm,&evtMask);
  if(evtMask&MS_RLSD_ON && evtMask&MS_CTS_ON && evtMask&MS_DSR_ON)
   return true;
 }
 else
  return false;
 return true; 
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
bool __fastcall TComPort::SetSpeed(int NewSpeed)
{
 if(hComm==INVALID_HANDLE_VALUE)
  return false;
 if(!GetCommState(hComm,&CurDCB))
 {
  CloseCom();
  return false;
 }
 CurDCB.BaudRate=NewSpeed;
 if(!SetCommState(hComm,&CurDCB))
 {
  CloseCom();
  return false;
 }
 return true;
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
bool __fastcall TComPort::SetTimeOuts(int NewTimeWait)
{
 if(hComm==INVALID_HANDLE_VALUE)
  return false;

 PortTimeOuts.ReadIntervalTimeout=NewTimeWait*1000;
 PortTimeOuts.ReadTotalTimeoutConstant=NewTimeWait*1000;
 PortTimeOuts.ReadTotalTimeoutMultiplier=NewTimeWait;
 PortTimeOuts.WriteTotalTimeoutMultiplier=NewTimeWait;
 PortTimeOuts.WriteTotalTimeoutConstant=NewTimeWait*100;
 if(!SetCommTimeouts(hComm,&PortTimeOuts))
  return false;
 return true;
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
bool __fastcall TComPort::SetTimeOutsDetail(int ReadInt, int ReadTotal, int ReadMult, int WriteMult, int WriteTotal)
{
 if(hComm==INVALID_HANDLE_VALUE)
  return false;

 PortTimeOuts.ReadIntervalTimeout=ReadInt;
 PortTimeOuts.ReadTotalTimeoutConstant=ReadTotal;
 PortTimeOuts.ReadTotalTimeoutMultiplier=ReadMult;
 PortTimeOuts.WriteTotalTimeoutMultiplier=WriteMult;
 PortTimeOuts.WriteTotalTimeoutConstant=WriteTotal;
 if(!SetCommTimeouts(hComm,&PortTimeOuts))
  return false;
 return true;
}
//---------------------------------------------------------------------------

