//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Read_Prog.h"
#include "common.h"
#include "commport.cpp"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}


//---------------------------------------------------------------------------
void __fastcall TForm1::btReadClick(TObject *Sender)
{
 AnsiString asMsg;
 TComPort myPort;
 unsigned char Send[8];
 unsigned char Rec[25];
 unsigned short crc;
 unsigned short i,j;
 int nResult;
 char Raskhod[3];
 char Temperature[3];
 char Pressure[3];
 char Frequency[3];
 float Q,T,P,F;
 unsigned int Volume;
 unsigned short Minuten;
 unsigned short Hours;
 unsigned short CountBytes;

 try { myPort.PortNumber=StrToInt(txComNumber->Text); }
 catch(...) {
  Application->MessageBox("  COM-!",NULL,MB_OK|MB_ICONERROR);
  ActiveControl=txComNumber;
  return ;
 }
 if(myPort.PortNumber<1 || myPort.PortNumber>256)         // ?
 {
  Application->MessageBox(" COM-      1  256!","!",MB_OK|MB_ICONERROR);
  ActiveControl=txComNumber;
  return;
 }
 if(cmbSpeed->ItemIndex==-1)
 {
  Application->MessageBox("  ","NULL",MB_OK|MB_ICONERROR);
  ActiveControl=cmbSpeed;
  return;
 }
 myPort.PortSpeed=StrToInt(cmbSpeed->Text);
 try { StrToInt(txNumPrib->Text); }
 catch(...) {                           //  
  Application->MessageBox("  ",NULL,MB_OK|MB_ICONERROR);
  ActiveControl=txNumPrib;
  return;
 }

 myPort.TimeWait=3;
 myPort.m_Phone[0]=0x0;
 if(!myPort.InitCom())
 {
  asMsg="  COM-  "+IntToStr(myPort.PortNumber)+"!";
  MessageBox(Handle,asMsg.c_str(),NULL,MB_OK|MB_ICONERROR);
  return;
 }

 //EventTimer ET;
 Send[0]=StrToInt(txNumPrib->Text);     // 
 Send[1]=3;                             //
 Send[2]=1;                             //    
 Send[3]=4;                             //.    
 Send[4]=0;                             //.  -   
 Send[5]=0xa;                           //.  -   
 crc=CRC16(Send,6);                     // CRC
 i=crc;
 j=i;
 j&=0x00FF;
 i>>=8;
 i&=0x00FF;
 Send[6]=j;
 Send[7]=i;
 crc=CRC16(Send,8);                     //, ..  

 myPort.ClearInputCom();
 myPort.ClearOutputCom();
 nResult=myPort.SendCom(Send,8);
 if(!nResult || nResult!=8)
 {
  myPort.CloseCom();
  asMsg="      "+IntToStr(myPort.PortNumber)+"!";
  MessageBox(Handle,asMsg.c_str(),NULL,MB_OK|MB_ICONERROR);
  return;
 }

 //***********************************
 //    3 
 nResult=myPort.ReceiveCom(Rec,3);
 if(!nResult)                                  //  - 
 {
  myPort.CloseCom();
  MessageBox(Handle,"   ",NULL,MB_OK|MB_ICONERROR);
  return;
 }
 if(nResult==3 && Rec[1]==0xC6)                 //  MODBUS
 {
  myPort.ReceiveCom(Rec+3,2);      // 
  myPort.CloseCom();
  asMsg=" ModBus  "+IntToStr(Rec[2])+"!";
  MessageBox(Handle,asMsg.c_str(),NULL,MB_OK|MB_ICONERROR);
  return;
 }
 if(nResult<3)                                 //  ,  
 {
  myPort.CloseCom();
  MessageBox(Handle,"      !",NULL,MB_OK|MB_ICONERROR);
  return;
 }

 //***********************************
 //  
 nResult=myPort.ReceiveCom(Rec+3,22);      
 myPort.CloseCom();
 if(!nResult)                                  //  - 
 {
  MessageBox(Handle,"   ",NULL,MB_OK|MB_ICONERROR);
  return;
 }
 if(nResult<22)                                 //  ,  
 {
  MessageBox(Handle,"      !",NULL,MB_OK|MB_ICONERROR);
  return;
 }

 //**************************
 // -    , -
 //******************************
 nResult=CRC16(Rec,25);
 if(nResult)
 {
  MessageBox(Handle," CRC   !",NULL,MB_OK|MB_ICONERROR);
  return;
 }

 Minuten=Rec[4];
 Hours=Rec[6]*256+Rec[3];
 txTime->Text=IntToStr(Hours)+":"+IntToStr(Minuten);
 Volume=Rec[9]*(256*256*256)+Rec[10]*(256*256)+Rec[7]*256+Rec[8];
 txV->Text=IntToStr(Volume);
 Raskhod[0]=Rec[12];                //.   
 Raskhod[1]=Rec[11];                //   
 Raskhod[2]=Rec[14];                // 
 Q=PICtoIARfloat(Raskhod);
 txQ->Text=FloatToStrF(Q,ffFixed,7,3);
 Temperature[0]=Rec[13];
 Temperature[1]=Rec[16];
 Temperature[2]=Rec[15];
 T=PICtoIARfloat(Temperature);
 txT->Text=FloatToStrF(T,ffGeneral,7,3);
 Pressure[0]=Rec[18];
 Pressure[1]=Rec[17];
 Pressure[2]=Rec[20];
 P=PICtoIARfloat(Pressure);
 txP->Text=FloatToStrF(P,ffFixed,7,3);
 Frequency[0]=Rec[19];
 Frequency[1]=Rec[22];
 Frequency[2]=Rec[21];
 F=PICtoIARfloat(Frequency);
 txF->Text=FloatToStrF(F,ffFixed,7,3);
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
//
 int ScHeight=Screen->Monitors[0]->Height;
 int ScWidth=Screen->Monitors[0]->Width;
 if(ScWidth<Width)
  Left=0;
 else
  Left=(ScWidth-Width)/2;
 if(ScHeight<Height)
  Top=0;
 else
  Top=(ScHeight-Height)/2;

 TRegistry& MyKeysReg = *new TRegistry ();
 bool KeysExist = MyKeysReg.OpenKey("Software\\Irvis\\Read-K300",true);
 //  ?
 if(KeysExist)
 {
  // COM- 
  if(MyKeysReg.ValueExists("Pribor-COM"))
   updComNumber->Position=MyKeysReg.ReadInteger("Pribor-COM");
  else
  {
   updComNumber->Position=1;
   MyKeysReg.WriteInteger("Pribor-COM",updComNumber->Position);
  }
  // 
  if(MyKeysReg.ValueExists("Pribor-Speed"))
   try { cmbSpeed->ItemIndex=MyKeysReg.ReadInteger("Pribor-Speed"); }
   catch(...) { cmbSpeed->ItemIndex=4; }
  else
  {
   cmbSpeed->ItemIndex=4;
   MyKeysReg.WriteInteger("Pribor-Speed",cmbSpeed->ItemIndex);
  }
  // 
  if(MyKeysReg.ValueExists("Pribor-Addr"))
   txNumPrib->Text=MyKeysReg.ReadString("Pribor-Addr");
  else
  {
   txNumPrib->Text="";
   MyKeysReg.WriteString("Pribor-Addr",txNumPrib->Text);
  }
  //   
  if(MyKeysReg.ValueExists("LeftWindowPos"))
   Left=MyKeysReg.ReadInteger("LeftWindowPos");
  if(MyKeysReg.ValueExists("TopWindowPos"))
   Top=MyKeysReg.ReadInteger("TopWindowPos");
 }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
 TRegistry& MyKeysReg = *new TRegistry ();
 bool KeysExist = MyKeysReg.OpenKey("Software\\Irvis\\Read-K300",true);
 if(KeysExist)
 {
  MyKeysReg.WriteInteger("Pribor-COM",updComNumber->Position);
  MyKeysReg.WriteInteger("Pribor-Speed",cmbSpeed->ItemIndex);
  MyKeysReg.WriteString("Pribor-Addr",txNumPrib->Text);
  MyKeysReg.WriteInteger("TopWindowPos",Top);
  MyKeysReg.WriteInteger("LeftWindowPos",Left);
 }
 delete &MyKeysReg;
}
//---------------------------------------------------------------------------

