//*******************************************
// CRC-16
//********************************************
unsigned int crc(unsigned int i,unsigned int j)
{
unsigned char n;
	i ^= j;
	for (n=8;n;n--)
	{
		if (i & 0x0001)
		{//    -1
		i >>= 1;
		i ^= 0xA001;
		}
		else
		{
		i >>= 1;
		}
	}
return i;
}
//=============================================

//******************************************
//    CRC-16
//   MODBUS
//------------------------------------------
//  CRC-16
//1) 16-    FFFFH.
//2)  XOR    
//   .
//   .
//3)     .
//4)    , 
// XOR   
// 1010 0000 0000 0001 (001).
//5)   ,    3.
//6)  3  4   ,   
// 8  .
//7)  XOR   
//  .
//8)  3-7   ,    
// XOR      .
//9)     
//CRC       
//
//******************************************
//:
//*buf-     
//NumBytes--   
//:
// CRC-16 (2 ). 
//  .
//------------------------------------------
unsigned int CRC16(unsigned char *buf, unsigned int NumBytes)
{
unsigned int i = 0xFFFF;	//. CRC-16
unsigned int j;
	for (;NumBytes ; NumBytes--)
	{
		j = (unsigned int)(*buf);
		i = crc(i,j);
		buf++;
	}
return i;
}
//===========================================

//*************************************************
//     
// PIC   IAR
//*************************************************
//     PIC
//3 
// 0-14 	-	mantissa (1  + 7 )
// 15 () -	s
// 16-23	-	exponenta (1 )
//N = (-1)(  s)*2(  (exponenta-127))*1.mantissa
//**************************************************
//     IAR
//4 
// 0-22	-	mantissa (2  + 7 )
// 23-30	-	exponenta (1 )
// 31 ()-	s
//N = (-1)(  s)*2(  (exponenta-127))*1.mantissa
//**************************************************
//*PICfloat-  .    
// PIC
float PICtoIARfloat(unsigned char *PICfloat)
{
union
{
float i;
unsigned char Byte[4]; 
} Number;
//  float IAR
	Number.Byte[0] = 0x00;
// 
	Number.Byte[1] = *(PICfloat+0);
// 
	Number.Byte[2] = *(PICfloat+1);
	Number.Byte[2] &= 0x7F;	// 

	if (*(PICfloat+2) & 0x01)
	{
	// . 
	Number.Byte[2] |= 0x80;
	}
// 
	Number.Byte[3] = *(PICfloat+2);
	Number.Byte[3] >>= 1;
	if (*(PICfloat+1) & 0x80)
	{
	//  
	Number.Byte[3] |= 0x80;
	}
	else
	{
	Number.Byte[3] &= 0x7F;
	}
return Number.i;
}
//*************************************************
