


//**************************************************
// -  
// 
//**************************************************
//:
//1 :	.-
//		.-
//:
//1  -  
unsigned char BCD2bin8(unsigned char BCD)
{
unsigned char i;
	i = BCD;
	i &= 0xF0;	//
	BCD &= 0x0F;	//
	while (i)
	{
	BCD += 10;	//+10
	i -= 0x10;
	}
return BCD;
}
//**************************************************



//**************************************************
//   
// -
//**************************************************
//:
//1  -  
//:
//1 :	.-
//		.-
unsigned char bin8BCD2(unsigned char bin)
{
unsigned char i;
	i = 0x00;
	while (bin >= 10)
	{
	bin -= 10;
	i += 0x10;
	}
	i += bin;
return i;
}
//**************************************************



//*************************************************
//     
// PIC   IAR
//*************************************************
//     PIC
//3 
// 0-14 	-	mantissa (1  + 7 )
// 15 () -	s
// 16-23	-	exponenta (1 )
//N = (-1)(  s)*2(  (exponenta-127))*1.mantissa
//**************************************************
//     IAR
//4 
// 0-22	-	mantissa (2  + 7 )
// 23-30	-	exponenta (1 )
// 31 ()-	s
//N = (-1)(  s)*2(  (exponenta-127))*1.mantissa
//**************************************************
//*PICfloat-  .    
// PIC
float PICtoIARfloat(unsigned char *PICfloat)
{
union
{
float i;
unsigned char Byte[4]; 
} Number;
//  float IAR
	Number.Byte[0] = 0x00;
// 
	Number.Byte[1] = *(PICfloat+0);
// 
	Number.Byte[2] = *(PICfloat+1);
	Number.Byte[2] &= 0x7F;	// 

	if (*(PICfloat+2) & 0x01)
	{
	// . 
	Number.Byte[2] |= 0x80;
	}
// 
	Number.Byte[3] = *(PICfloat+2);
	Number.Byte[3] >>= 1;
	if (*(PICfloat+1) & 0x80)
	{
	//  
	Number.Byte[3] |= 0x80;
	}
	else
	{
	Number.Byte[3] &= 0x7F;
	}
return Number.i;
}
//*************************************************



/*
Assembler
;============ Yfloat_Zpic ======================================	
;   
; z-. 
; :    
;	xh:xl- ,yl- 
;  :zh,zl,yh,yl,xl 
;----------------------------------------------------------------
Yfloat_Zpic:
	ldd xl,z+0
	ldd xh,z+1		;
	sbr xh,0b10000000	; 1  ...
	ldd temp,z+2		;
	clr yl			; 
	ldi yh,$8E
	sub yh,temp		;YH - - -  
	breq Ypic7		; =0
Ypic1:	
	lsr xh
	ror xl
	ror yl
	dec yh
	brne Ypic1
Ypic7:
	ret
;================================================
*/



//*************************************************
//     
//     
//*************************************************
//     IAR
//4 
// 0-22	-	mantissa (2  + 7 )
// 23-30	-	exponenta (1 )
// 31 ()-	s
//N = (-1)(  s)*2(  (exponenta-127))*1.mantissa
//*************************************************
//*n-    
//*Integer-    (   4 )
//*Fract-    (   1 )
void FloatToBIN(float *n,unsigned long *Integer,unsigned char *Fract)
{
union
{
float i;
unsigned char j[4];
} Number;

union
{
unsigned long i;
unsigned char j[4];
} IntPart;

unsigned char i;
unsigned char FractPart;

//
	Number.i = *n;
// 
	IntPart.j[0] = Number.j[0];
	IntPart.j[1] = Number.j[1];
	IntPart.j[2] = Number.j[2];
	IntPart.j[3] = 0x00;
// 1
	IntPart.j[2] |= 0x80;
//
	i = Number.j[3];
	i <<= 1;
	if (Number.j[2] & 0x80)
	{
	i |= 0x01;
	}
	else
	{
	i &= 0xFE;
	}
// 
	FractPart = 0x00;
//      
	if (i <= 0x96)
	{
//-  
	i = (0x96 - i);
//    
		while (i)
		{
		FractPart >>= 1;
			if (IntPart.j[0] & 0x01)
			{
			FractPart |= 0x80;
			}
			else
			{
			FractPart &= 0x7F;
			}
		IntPart.i >>= 1;
		i--;
		}
	}
	else
	{
//-  
	i = (i - 0x96);
//    
		while (i)
		{
		IntPart.i <<= 1;
		i--;
		}
	}

	*Integer = IntPart.i;
	*Fract = FractPart;
}
//*************************************************




//*************************************************
//   - ,
// 
//*************************************************
//  ()  -
//(0x00-0x09)
//:
//a-  ()
//b-  ()
//n--  ()
//:
//a-- 
void SumBCD(unsigned char *a,unsigned char *b,unsigned char n)
{
unsigned char i;
unsigned char j;
unsigned char sum;
	i = 0x00;
	j = 0x00;
	while (n)
	{
	sum = ( (*(a+i))+(*(b+i))+j );
		if (sum > 0x09)
		{
		sum -= 0x0A;
		j = 0x01;
		}
		else
		{
		j = 0x00;
		}
	*(a+i) = sum;
	i++;
	n--;
	}
}
//*************************************************




//*************************************************
//   
// -
//*************************************************
//1)*Number-   
//4 -max 0xFF.FF.FF.FF = 42.94.96.72.95
//2)*buf- ,   
//3)n--  
void BINtoBCD(unsigned long *Number,unsigned char *buf,unsigned char n)
{
unsigned char i;
unsigned char *Ad;
// 
	Ad = (unsigned char *)malloc(n);
//   (1- -0x01, 0x00)
	*Ad = 0x01;
	i = 1;
	while (i<n)
	{
	*(Ad+i) = 0x00;
	i++;
	}
//.
	i=0;
	while (i<n)
	{
	*(buf+i) = 0x00;
	i++;
	}
//- --  
	i = (sizeof(long)*8);
	while (i)
	{
		if (*Number & 0x00000001)
		{
		SumBCD(buf,Ad,n);
		}
	SumBCD(Ad,Ad,n);
	*Number >>= 1;
	i--;
	}
// 
	free(Ad);
}
//*************************************************


//****************************************
// ""  
//  ASCII 0x30   
// 0x20
//---------------------------------------
// ASCII   RAM  
//.  . ( )
//---------------------------------------
//:
//*sym-  () 
//n--  
void DeleteNulls(unsigned char *sym,unsigned char n)
{
	for (;n;n--)
	{
		if (*sym == 0x30)
		{
		*sym = 0x20;	//  
		sym++;		//   
		}
		else
		{
		break;
		}
	}
}
//****************************************


//*************************************************
//      
//      ASCII 
//*************************************************
//   
//*************************************************
//:
//buf1-  
//n--   
//buf2-  
//:
//    (buf1)    
//(buf2)
void EndBf1ToBegBuf2ASCII(unsigned char *buf1,unsigned char *buf2, \
unsigned char n)
{
unsigned char i;
	buf1 += (n-1);
	i = 0x00;
	while (i<n)
	{
	*buf2 = (*buf1|0x30);
	buf1--;
	buf2++;
	i++;
	}
}
//*************************************************


//*************************************************
//   long  ASCII
//   
//1)*L-   
//2)*buf-    ( .)
//3)n--  
void LongToString(unsigned long *L,unsigned char *buf, \
unsigned char n)
{
unsigned char *p;

//  
	p = (unsigned char *)malloc(n);
//  BCD
	BINtoBCD(L,p,n);
	//   RAM
	EndBf1ToBegBuf2ASCII(p,buf,n);
	//   
	DeleteNulls(buf,n-1);
	free(p);
}
//*************************************************



//*************************************************
//      ASCII
//   
//*************************************************
//   1 
//*************************************************
//Fl-   (  )
//buf-    (.   )
//n1--   
//s-   	(  "-")
// s = Null-  
//  -    (buf+0)
void FloatToString(float *Fl,unsigned char *buf,unsigned char n1, \
unsigned char *s)
{
unsigned char i;
union
{
float F;
unsigned char i[4];
} Un;
// 
unsigned long L;
// 
unsigned char F;
// 
unsigned char *Bf;
unsigned char *Ad;
//   
	Bf = (unsigned char *)malloc(n1+2);
	Un.F = *Fl;
	//        
	Un.F *= 100;
	//    
	//Un.F-,L- ,F- 
	FloatToBIN(&Un.F,&L,&F);
	//    BCD
	//L- (4 ),Bf--  (10 )
	//  Bf[1,0]-  
	BINtoBCD(&L,Bf,(n1+2));
	//
		if (*(Bf+0) > 0x04)
		{
		// . 5  -   
		//   
		Ad = (unsigned char *)malloc(n1+1);
		*(Ad+0) = 0x01;
			i = 1;
			while (i<(n1+1))
			{
			*(Ad+i) = 0x00;
			i++;
			}
		SumBCD((Bf+1),Ad,(n1+1));
		// 
		free(Ad);
		}
	//   
	//  Bf[n1+1]-Bf[1]
	i = 0;
	while (i<n1)
	{
	*(buf+i) = (*(Bf+n1+1-i)|0x30);
	i++;
	}
	// ASCII 
	*(buf+n1) = '.';
	// 
	*(buf+n1+1) = (*(Bf+1)|0x30);
// 
	if (s)
	{
	//  
		if (Un.i[3] & 0x80)
		{
		//  
		*s = '-';
		}
		else
		{
		//  
		*s = '+';
		}
	}
	//  
	DeleteNulls(buf,(n1-1));
// 
	free(Bf);
}
//*************************************************


//*****************************************
//  -
// (.-,.-)
// -  
//:
//*InValue-   (1 )
//*OutValue-    (2 -,2 )
//   .   ( )
//.. *OutValue-.:*(OutValue+1)-.
//:
//
void BCDtoASCII(unsigned char *InValue,unsigned char *OutValue)
{
unsigned char i;
//.
	i = *InValue;
	i >>= 4;	//.
	i &= 0x0F;	//
	i |= 0x30;	//-- ASCII
	*OutValue = i;
//.
	i = *InValue;
	i &= 0x0F;	// .
	i |= 0x30;	//-- ASCII
	OutValue++;
	*OutValue = i;	
}
//****************************************


//****************************************
//  unsigned int
// float
//****************************************
//     IAR
//4 
// 0-22	-	mantissa (2  + 7 )
// 23-30	-	exponenta (1 )
// 31 ()-	s
//N = (-1)(  s)*2(  (exponenta-127))*1.mantissa
float UnsignedIntToFloat(unsigned int i)
{
unsigned char exp = 127+15;	//
union {
unsigned long mantissa;
float f;
unsigned char m[4];
} temp;
//unsigned char j;
	if (i == 0)
	{
	return 0.0;
	}
	
	temp.m[0] = 0x00;
	temp.m[1] = ((unsigned char)i);
	temp.m[2] = ((unsigned char)(i>>8));
//	temp.m[3] = 0x00;
	//   ,   1  23 
//	j = 0x10;
	while ((temp.m[2] & 0x80) == 0x00)
	{
	exp--;
	temp.mantissa <<= 1;
	//  , . = 0
//	j--;
//		if (j)
//		{;}
//		else
//		{
//		break;
//		}
	}
//      IAR
	if (exp & 0x01)
	{
	// .   "1"
	;}
	else
	{
	//, .  -  "0"
	temp.m[2] &= (0x7F);
	}
	exp >>= 1;
	temp.m[3] = exp;
return temp.f;
}
//****************************************




//****************************************
// unsigned int  ASCII
//****************************************
void UnsignedIntToASCII(unsigned int i,unsigned char *OutBuf)
{
unsigned long L;
unsigned char buf[5];
	L = (unsigned long)i;
	//  BCD
	BINtoBCD(&L,&buf[0],5);
	//   
	EndBf1ToBegBuf2ASCII(&buf[0],OutBuf,5);
	//   0
	DeleteNulls(OutBuf,4);
}
//****************************************


//****************************************
// unsigned char  ASCII
//****************************************
void UnsignedCharToASCII(unsigned char i,unsigned char *OutBuf)
{
unsigned long L;
unsigned char buf[3];
	L = (unsigned long)i;
	//  BCD
	BINtoBCD(&L,&buf[0],3);
	//   
	EndBf1ToBegBuf2ASCII(&buf[0],OutBuf,3);
	//   0
	DeleteNulls(OutBuf,2);
}
//****************************************


//*************************************************
//     
//double      
//*************************************************
//    double  IAR
//4 
// 0-51	-	mantissa (6  + 4 )
// 52-62	-	exponenta (1 )
// 63 ()-	s
//N = (-1)(  s)*2(  (exponenta-1023))*1.mantissa
//*************************************************
//*n-    
//*Integer-    (   4 )
//*Fract-    (   1 )
/*
void DoubleToBIN(double *n,unsigned long *Integer,unsigned char *Fract)
{
union
{
double i;
unsigned char j[8];
} Number;

union
{
unsigned long i;
unsigned char j[8];
} IntPart;

union{
unsigned int i;
unsigned char j[2];
} exp;

unsigned char FractPart;

//
	Number.i = *n;
// 
	IntPart.j[0] = Number.j[0];
	IntPart.j[1] = Number.j[1];
	IntPart.j[2] = Number.j[2];
	IntPart.j[3] = Number.j[3];
	IntPart.j[4] = Number.j[4];
	IntPart.j[5] = Number.j[5];
	IntPart.j[6] = Number.j[6];
	IntPart.j[6] &= 0x0F;
// 1
	IntPart.j[6] |= 0x10;
	IntPart.j[7] = 0x00;
//
	exp.j[0] = Number.j[6];
	exp.j[1] = Number.j[7];
	// 
	exp.j[1] &= 0x7F;
	exp.i >>= 4;
	
//-  
	//1023+52=1075
	exp.i = (0x0433 - exp.i);
// 
	FractPart = 0x00;
//    
	while (exp.i)
	{
	FractPart >>= 1;
		if (IntPart.j[0] & 0x01)
		{
		FractPart |= 0x80;
		}
		else
		{
		FractPart &= 0x7F;
		}
	IntPart.i >>= 1;
	exp.i--;
	}
	*Integer = IntPart.i;
	*Fract = FractPart;
}*/
//*************************************************
